#version 330
#extension GL_EXT_gpu_shader4 : enable
// alijaya - DrosteMod01.fsh  by  alijaya

//https://www.shadertoy.com/view/4tByz1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926535897932384626433832795

vec2 cexp( vec2 c ) {
    return exp(c.x) * vec2(cos(c.y), sin(c.y));
}

vec2 clog( vec2 c ) {
    return vec2(log(sqrt(c.x*c.x+c.y*c.y)), atan(c.y, c.x));
}

vec2 crec( vec2 c ) {
    return vec2(c.x, -c.y) / (c.x*c.x+c.y*c.y);
}

vec2 cmul( vec2 a, vec2 b ) {
    return vec2(a.x*b.x-a.y*b.y, a.x*b.y+a.y*b.x);
}

vec2 cdiv( vec2 a, vec2 b ) {
    return cmul(a, crec(b));
}

float r1 = 0.2;
float r2 = 1.0;
int depth = 2;

float circle( vec2 xy, vec2 pos, float radius ) {
    float smoothness = 1.0;
    
    float ret = 1.0 - smoothstep( radius - smoothness, radius, distance( xy, pos ) );
    return ret;
}

float circleO( vec2 xy, vec2 pos, float radius, float thickness ) {
    float smoothness = 1.0;
    
    float dist = distance( xy, pos );
    radius += thickness / 2.0;
    float ret = 1.0 - smoothstep( radius - smoothness, radius, dist );
    radius -= thickness;
    ret -= 1.0 - smoothstep( radius, radius + smoothness, dist );
    return ret;
}

float lineO( vec2 xy, vec2 a, vec2 b, float thickness ) {
    float smoothness = 1.0;
    
    vec2 ab = b - a;
    float lab = length(ab);
    vec2 nab = normalize(ab);
    vec2 axy = xy - a;
    float d = dot(nab, axy);
    float dist = length(nab * d - axy);
    
    thickness /= 2.0;
    float ret = 1.0 - smoothstep( thickness - smoothness, thickness, dist );
    ret *= smoothstep(-thickness, -thickness + smoothness, d);
    ret *= 1.0 - smoothstep( lab + thickness - smoothness, lab + thickness, d);
    return ret;
}

vec3 draw( vec2 xy ) {
    float c0 = circleO( xy, vec2(0.0), r1, 5.0 );
    float c1 = circleO( xy, vec2(0.0), r2, 5.0 );
    float l0 = lineO( xy, vec2(r1, 0.0), vec2(r2, 0.0), 5.0 );
    float l1 = lineO( xy, vec2(0.0, r1), vec2(0.0, r2), 5.0 );
    float l2 = lineO( xy, vec2(-r1, 0.0), vec2(-r2, 0.0), 5.0 );
    float l3 = lineO( xy, vec2(0.0, -r1), vec2(0.0, -r2), 5.0 );
    
    vec3 color0 = vec3(1.0, 0.0, 0.0);
    vec3 color1 = vec3(1.0, 1.0, 0.0);
    vec3 color2 = vec3(0.0, 1.0, 0.0);
    vec3 color3 = vec3(0.0, 1.0, 1.0);
    vec3 color4 = vec3(0.0, 0.0, 1.0);
    vec3 color5 = vec3(1.0, 0.0, 1.0);
    
    vec3 color = vec3(0.0);
    color = mix(color, color0, c0);
    color = mix(color, color1, c1);
    color = mix(color, color2, l0);
    color = mix(color, color3, l1);
    color = mix(color, color4, l2);
    color = mix(color, color5, l3);
    
    return color;
}

vec2 droste( vec2 xy, float r1, float r2, int depth ) {
    float scale = log(r2 / r1);
    float angle = atan(scale, 2.0 * PI);
    xy = clog(xy);
    xy = cdiv(xy, cexp(vec2(0, angle)) * cos(angle));
    xy.x += fract(iTime) * scale;
    xy.x = mod(xy.x, scale) + float(depth) * scale;
    xy = cexp(xy) * r1;
    
    return xy;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    vec2 center = iResolution.xy / 2.0;
    vec2 xy = gl_FragCoord.xy - center;
    float res = min(iResolution.x, iResolution.y);
    vec2 res2 = vec2(res);
    r1 *= res / 2.0;
    r2 *= res / 2.0;
    
    gl_FragColor = vec4(0.0);
    for (int i = depth; i >= 0; i--) {
        vec2 uvxy = droste(xy, r1, r2, i) / iResolution.xy;

        vec4 color = texture2D(iChannel0, uvxy + vec2(0.5));
        float pct = smoothstep(0.0, 0.5, 1.0 - distance( vec2(0,0), uvxy ) / 0.5);
        color = mix(color, vec4(0.0), pct);
        gl_FragColor = mix(gl_FragColor, color, color.a);
    }
    
    //gl_FragColor = vec4(draw(droste(xy, r1, r2, 0)), 1.0);
}